#include <iostream>
#include <vector>
#include <algorithm>

struct P {
    int x, y;
};

int cross(P o, P a, P b) {
    return (a.x - o.x) * (b.y - o.y) - (a.y - o.y) * (b.x - o.x);
}

int main() {
    int n;
    std::cin >> n;
    std::vector<P> p(n);

    for (int i = 0; i < n; ++i) {
        std::cin >> p[i].x >> p[i].y;
    }

    std::sort(p.begin(), p.end(), [](P a, P b) {
        return a.x != b.x ? a.x < b.x : a.y < b.y;
    });

    std::vector<P> l, u;
    for (int i = 0; i < n; ++i) {
        while (l.size() >= 2 && cross(l[l.size() - 2], l.back(), p[i]) <= 0) l.pop_back();
        l.push_back(p[i]);
    }

    for (int i = n - 1; i >= 0; --i) {
        while (u.size() >= 2 && cross(u[u.size() - 2], u.back(), p[i]) <= 0) u.pop_back();
        u.push_back(p[i]);
    }

    l.pop_back();
    u.pop_back();
    l.insert(l.end(), u.begin(), u.end());

    int area = 0;
    for (int i = 0; i < l.size(); ++i) {
        int j = (i + 1) % l.size();
        area += l[i].x * l[j].y - l[i].y * l[j].x;
    }

    std::cout << std::abs(area) / 2 << std::endl;

    return 0;
}